package com.anplus.hr.domain;

import io.github.linpeilie.annotations.AutoMapper;
import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 部门职位月度统计对象 staffing_position_month_summary
 *
 * @author LiuBin
 * @date 2025-12-16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = StaffingPlanData.class, convertGenerate = false)
@TableName("staffing_position_month_summary")
public class StaffingPositionMonthSummary extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 一级部门ID
     */
    private Long lv1DeptId;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 正式开始人数
     */
    private Integer formalStartCount;

    /**
     * 正式结束人数
     */
    private Integer formalEndCount;

    /**
     * 兼职开始人数
     */
    private Integer partStartCount;

    /**
     * 兼职结束人数
     */
    private Integer partEndCount;


}
