package com.anplus.hr.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.mybatis.bean.model.TenantModel;

import java.io.Serial;

/**
 * 员工部门对象 employee_dept
 *
 * @author LiuBin
 * @date 2025-10-30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_dept")
public class EmployeeDept extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 父级部门
     */
    private Long parentId;

    /**
     * 父级部门名称
     */
    private String parentName;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 部门层级
     */
    private Integer level;

    /**
     * 祖级关系
     */
    private String nodePath;

    /**
     * 显示顺序
     */
    private Long orderNum;

    /**
     * 状态
     */
    private Integer status;


}
