package com.anplus.hr.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 刘斌
 * @date 2025/11/17 20:26
 */
@Getter
@AllArgsConstructor
public enum HrResignYearsOfServiceTypeEnum {

    PROBATION_PERIOD("1", "试用期内", 6),
    UNDER_THREE_YEARS("2", "入职3年内", 36),
    OVER_THREE_YEARS("3", "入职3年以上", 1200);

    private final String code;

    private final String name;

    private final int monthsLimit;



    public static HrResignYearsOfServiceTypeEnum getByTotalMonths(Integer totalMonths) {
        if (totalMonths == null || totalMonths <= 0) {
            return null;
        }
        for (HrResignYearsOfServiceTypeEnum value : values()) {
            if (totalMonths < value.monthsLimit) {
                return value;
            }
        }
        return null;
    }
}
