package com.anplus.hr.config;

import cn.idev.excel.write.handler.RowWriteHandler;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author 刘斌
 * 2025/12/15 19:25
 */
public class StaffingPlanExportHandler implements RowWriteHandler {

    // 定义合计行的标识
    private static final String DEPARTMENT_TOTAL = "部门合计";
    private static final String AREA_TOTAL = "片区合计";

    // 定义背景色（浅灰色）
    private static final IndexedColors BACKGROUND_COLOR = IndexedColors.GREY_25_PERCENT;

    // 缓存样式，避免重复创建
    private final Map<String, CellStyle> styleCache = new HashMap<>();

    @Override
    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder,
                                Row row, Integer relativeRowIndex, Boolean isHead) {
        Sheet sheet = writeSheetHolder.getSheet();
        Workbook workbook = sheet.getWorkbook();

        // 遍历行，找到合计行
//        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); rowIndex++) {
//            int rowNum = row.getRowNum();
//
        // 获取板块列的值（假设是第一列，索引0）
        Cell plateCell = row.getCell(0);
        if (plateCell == null) {
            return;
        }

        // 获取单元格值，处理可能为null的情况
        String cellValue;
        if (Objects.requireNonNull(plateCell.getCellType()) == CellType.STRING) {
            cellValue = plateCell.getStringCellValue();
        } else {
            return;
        }
        if (DEPARTMENT_TOTAL.equals(cellValue) || AREA_TOTAL.equals(cellValue)) {
            int rowNum = row.getRowNum();

            // 合并前四列（0-3列）
            CellRangeAddress region = new CellRangeAddress(rowNum, rowNum, 0, 3);
            sheet.addMergedRegion(region);

            // 获取或创建样式
            CellStyle style = getOrCreateStyle(workbook, cellValue);

            if (DEPARTMENT_TOTAL.equals(cellValue)) {
                style.setFillForegroundColor(IndexedColors.ROSE.getIndex());
            } else {
                style.setFillForegroundColor(IndexedColors.RED.getIndex());
            }

            // 为合并后的单元格设置样式
            for (int col = 0; col <= 3; col++) {
                Cell cell = row.getCell(col);
                if (cell == null) {
                    cell = row.createCell(col);
                }
                cell.setCellStyle(style);
            }

//                // 如果需要，清空第5列（岗位名称）的内容
//                Cell positionCell = row.getCell(4);
//                if (positionCell != null) {
//                    positionCell.setCellValue("");
//                    positionCell.setCellStyle(style);
//                }
        }
//        }
    }

    /**
     * 获取或创建单元格样式
     */
    private CellStyle getOrCreateStyle(Workbook workbook, String cellValue) {
        return styleCache.computeIfAbsent(cellValue, cv -> {
            CellStyle style = workbook.createCellStyle();
            // 设置背景色
            style.setFillForegroundColor(BACKGROUND_COLOR.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);

            // 设置对齐方式
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);

            // 设置边框
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);

            return style;
        });
    }

}
